#ifndef __PICO_H__
#define __PICO_H__


#define IO_REGION(name, addr) (*(volatile struct name *)(addr))

/* offsets to add to 4kB I/O regions for atomic bitwise manipulation */
#define HW_XOR(_a, _v) *((volatile unsigned *)(((char *)&(_a)) + 0x1000)) = (_v)
#define HW_OR(_a, _v) *((volatile unsigned *)(((char *)&(_a)) + 0x2000)) = (_v)
#define HW_ANDNOT(_a, _v) *((volatile unsigned *)(((char *)&(_a)) + 0x3000)) = (_v)

struct clocks_rec {			/* pg197 */
	unsigned gpout0_ctrl, gpout0_div, gpout0_selected;
	unsigned gpout1_ctrl, gpout1_div, gpout1_selected;
	unsigned gpout2_ctrl, gpout2_div, gpout2_selected;
	unsigned gpout3_ctrl, gpout3_div, gpout3_selected;
	unsigned ref_ctrl, ref_div, ref_selected;
	unsigned sys_ctrl, sys_div, sys_selected;
	unsigned peri_ctrl, peri_div, peri_selected;
	unsigned usb_ctrl, usb_div, usb_selected;
	unsigned adc_ctrl, adc_div, adc_selected;
	unsigned rtc_ctrl, rtc_div, rtc_selected;
	unsigned sys_resus_ctrl, sys_resus_status;
	unsigned fc0_ref_khz, fc0_min_khz, fc0_max_khz;
	unsigned fc0_delay, fc0_interval, fc0_src, fc0_status, fc0_result;
	unsigned wake_en0, wake_en1;
	unsigned sleep_en0, sleep_en1;
	unsigned enabled0, enabled1;
	unsigned intr, inte, intf, ints;
};
#define clocks IO_REGION(clocks_rec, 0x40008000)

struct resets_rec {		/* pg179 */
	unsigned reset, wdsel, reset_done;
};
#define resets IO_REGION(resets_rec, 0x4000c000)

struct xosc_rec {		/* pg221 */
	unsigned ctrl, status, dormant, startup;
	unsigned reserved[3], count;
};
#define xosc IO_REGION(xosc_rec, 0x40024000)

struct rosc_rec {		/* pg225 */
	unsigned ctrl, freqa, freqb, dormant;
	unsigned div, phase, status, randombit;
	unsigned count;
};
#define rosc IO_REGION(rosc_rec, 0x40060000)

struct io_bank0_rec {		/* pg244 */
	struct { unsigned status, ctrl; } gpio[30];
	unsigned intr0, intr1, intr2, intr3;
	unsigned proc0_inte0, proc0_inte1, proc0_inte2, proc0_inte3;
	unsigned proc0_intf0, proc0_intf1, proc0_intf2, proc0_intf3;
	unsigned proc0_ints0, proc0_ints1, proc0_ints2, proc0_ints3;
	unsigned proc1_inte0, proc1_inte1, proc1_inte2, proc1_inte3;
	unsigned proc1_intf0, proc1_intf1, proc1_intf2, proc1_intf3;
	unsigned proc1_ints0, proc1_ints1, proc1_ints2, proc1_ints3;
	unsigned dormant_wake_inte0, dormant_wake_inte1;
	unsigned dormant_wake_inte2, dormant_wake_inte3;
	unsigned dormant_wake_intf0, dormant_wake_intf1;
	unsigned dormant_wake_intf2, dormant_wake_intf3;
	unsigned dormant_wake_ints0, dormant_wake_ints1;
	unsigned dormant_wake_ints2, dormant_wake_ints3;
};
#define io_bank0 IO_REGION(io_bank0_rec, 0x40014000)

struct psm_rec {		/* pg173 */
	unsigned frce_on, frce_off, wdsel, done;
};
#define psm IO_REGION(psm_rec, 0x40010000)

struct wdt_rec {		/* pg548 */
	unsigned ctrl, load, reason, scratch[8], tick;
};
#define wdt IO_REGION(wdt_rec, 0x40058000)

struct ssi_rec {		/* pg600 */
	unsigned ctrlr0, ctrlr1, ssienr, mwcr;
	unsigned ser, baudr, txftlr, rxftlr;
	unsigned txflr, rxflr, sr, imr;
	unsigned isr, risr, txoicr, rxoicr;
	unsigned rxuicr, msticr, icr, dmacr;
	unsigned dmatdlr, dmardlr, idr, ssi_version_id;
};
#define ssi IO_REGION(ssi_rec, 0x18000000)

struct xip_rec {		/* pg128 */
	unsigned ctrl, flush, stat, ctr_hit;
	unsigned ctr_acc, stream_addr, stream_ctr, stream_fifo;
};
#define xip IO_REGION(xip_rec, 0x14000000)

typedef void (*vfunc)(void);
struct bootrom_rec {		/* pg135 */
	void *boot_sp;
	vfunc reset, nmi, hardfault;
	unsigned char magic[3], version;
	unsigned short rom_func_table;
	unsigned short rom_data_table;
	unsigned short rom_table_lookup;
};
#define bootrom IO_REGION(bootrom_rec, 0x00000000)
#define BOOTROM_CODE(_s) (((_s[1])<<8) | (_s[0]))
typedef void *(*rom_table_lookup_fn)(unsigned short *table, unsigned code);
#define BOOTROM_FIND_FUNC(_s) \
	(((rom_table_lookup_fn)(int)bootrom.rom_table_lookup)( \
			(void*)(int)bootrom.rom_func_table, BOOTROM_CODE(_s)))
#define BOOTROM_FIND_DATA(_s) \
	(((rom_table_lookup_fn)(int)bootrom.rom_table_lookup)( \
			(void*)(int)bootrom.rom_data_table, BOOTROM_CODE(_s)))
#define _connect_internal_flash ((vfunc)BOOTROM_FIND_FUNC("IF"))
#define _flash_enter_cmd_xip ((vfunc)BOOTROM_FIND_FUNC("CX"))
#define _flash_exit_xip ((vfunc)BOOTROM_FIND_FUNC("EX"))
#define _reset_to_usb_boot \
	((void (*)(unsigned gpio_activity_pin_mask, \
		unsigned disable_interface_mask))BOOTROM_FIND_FUNC("UB"))


struct systick_rec {		/* ARMv6-M pg238 (or rp2040 pg78) */
	unsigned csr, rvr, cvr, calib;
};
#define syst IO_REGION(systick_rec, 0xe000e010)

struct nvic_rec {		/* ARMv6-M pg245 (or rp2040 pg78) */
	unsigned iser, __res1[31];
	unsigned icer, __res2[31];
	unsigned ispr, __res3[31];
	unsigned icpr, __res4[31];
	unsigned ipr[8];
};
#define nvic IO_REGION(nvic_rec, 0xe000e100)

struct scb_rec {		/* ARMv6-M pg228 (or rp2040 pg78) */
	unsigned cpuid, icsr;
	void *vtor;		/* XXX - must be 256-byte aligned! */
	unsigned aircr;
	unsigned scr, ccr, __res1, shpr2;
	unsigned shpr3, shcsr, __res2[2];
	unsigned dfsr;
};
#define scb IO_REGION(scb_rec, 0xe000ed00)

struct vtor_rec {		/* ARMv6-M pg192 */
	void *sp_main;		/* %sp at reset */
	vfunc reset, nmi, hardfault;
	unsigned __res1[7];
	vfunc svcall;
	unsigned __res2[2];
	vfunc pendsv, systick;
	vfunc ext[32];		/* from NVIC */
};


#endif /* __PICO_H__ */
