/* This crt0 can be built in 3 ways:
 *  --defsym crt0_mode=0   "sram"
 *     Boot from SRAM.  Establish a stack pointer and branch to main.  All of
 *     the sections are already loaded in SRAM, even .bss.
 *  --defsym crt0_mode=1   "fl"    (flash loader)
 *     Copy code (.text .rodata .data) from FLASH into SRAM, and then execute
 *     in SRAM.
 *  --defsym crt0_mode=2   "xip"   (execute in place)
 *     Copy only writable data (.data) from FLASH into SRAM, and then execute
 *     in place.
 */

.syntax unified

.section .stack
/* define empty sym for stack.  ldscript gives it an addr and 4k of SRAM */

.section .start
.global start
.type start,function
start:
	ldr r0,=.stack+4096	/* stack grows towards smaller addrs */
	mov sp,r0

.if (crt0_mode > 0)
	/* All flash loaders need to copy something from flash into SRAM */
	ldr r1,=('I'|('F'<<8))		// _connect_internal_flash "IF"
	bl crt0_lookup
	blx r4

	ldr r1,=('C'|('X'<<8))		// _flash_enter_cmd_xip "CX"
	bl crt0_lookup
	blx r4

	/* initializes _initdst.._initdstend with data from _initsrc
	 * fl: .text .rodata .data
	 * xip: .data */
	ldr r0,=_initdst
	ldr r1,=_initdstend
	ldr r2,=_initsrc
copy_loop:
	cmp r0,r1
	bge copy_done
	ldmia r2!,{r3}		/* r3 = *(r2++) */
	stmia r0!,{r3}
	b copy_loop
copy_done:
	/* then zero from _initdstend.._initbssend (init .bss) */
	ldr r1,=_initbssend
	movs r3,#0
zero_loop:
	cmp r0,r1
	bge zero_done
	stmia r0!,{r3}
	b zero_loop
zero_done:

.if (crt0_mode == 1)
	/* Done reading flash, so exit XIP mode */
	ldr r1,=('E'|('X'<<8))		// _flash_exit_xip "EX"
	bl crt0_lookup
	blx r4
.endif
.endif

	ldr r0,=main
	blx r0

	ldr r1,=('U'|('B'<<8))		// _reset_to_usb_boot "UB"
	bl crt0_lookup
	movs r0,#0			// arguments 0,0 means enable USB
	movs r1,#0
	blx r4

loop:	b loop
	.ltorg


/* Looks up a function in the bootrom.
 * Takes the code for the function in r1 (ldr r1,=('c1'|('c2'<<8))).
 * Returns a pointer to the function in r4.  Trashes r0-r4. */
crt0_lookup:
	push {lr}
	movs r4,#0			// bootrom offset
	ldrh r0,[r4,#0x14]		// rom_func_table
	ldrh r4,[r4,#0x18]		// rom_table_lookup()
	blx r4
	mov r4,r0
	pop {pc}
	.ltorg
